'use strict';

/* --------------------------------------------------------------
 session_timeout.js 2016-11-10
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2011 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

gx.extensions.module('session_timeout', [], function (data) {

    'use strict';

    // ------------------------------------------------------------------------
    // VARIABLES
    // ------------------------------------------------------------------------

    var
    /**
     * Module Selector
     *
     * @type {object}
     */
    $this = $(this),


    /**
     * Default Options
     *
     * @type {object}
     */
    defaults = {
        url: jse.core.config.get('appUrl') + '/admin/admin.php?do=SessionTimeoutAjax',
        timeout: 1000
    },


    /**
     * Final Options
     *
     * @type {object}
     */
    options = $.extend(true, {}, defaults, data),


    /**
     * Module Object
     *
     * @type {object}
     */
    module = {};

    // ------------------------------------------------------------------------
    // FUNCTIONS
    // ------------------------------------------------------------------------

    /**
     * Is firing by <div data-gx-extension="session_timeout" hidden></div>
     *
     * @see admin/html/content/admin_menu.html
     * @private
     */
    var _initializeTimeout = function _initializeTimeout() {
        $.getJSON(options.url).done(function (response) {
            if (response.logout === true) {
                return;
            }

            options.timeout = response.data[0];
            setTimeout(_initializeTimeout, options.timeout);
        });
    };

    // ------------------------------------------------------------------------
    // INITIALIZATION
    // ------------------------------------------------------------------------

    module.init = function (done) {
        $(document).on('JSENGINE_INIT_FINISHED', _initializeTimeout);

        done();
    };

    return module;
});
//# sourceMappingURL=data:application/json;charset=utf8;base64,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
